// Filter Willow
__kernel void MAIN(__read_only image2d_t image,   		// input image
				   __write_only image2d_t retImage,   	// image result
				   __global FilterParam* param,
				   __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_global_size(0);
	int height = get_global_size(1);
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	
//	if(w < width && h < height)
	{
		float factor = 1.0f;//
		float4 orig = read_imagef(image, sampler, (int2)(w, h)); 
		uchar4 color = convert_uchar4(read_imagef(image, sampler, (int2)(w, h)) * 255);
		int r = (int)(color.x);
		int g = (int)(color.y);
		int b = (int)(color.z);
		int a = (int)(color.w);
		int intColor = (int)((a << 24) | (r << 16) | (g << 8) | b);
		int tmpbw = (b + g + r) / 3;
		tmpbw = (a << 24) | (tmpbw << 16) | (tmpbw << 8) | tmpbw;
		int ret = (int)(tmpbw * factor + (1.0f - factor) * intColor);
		
		float4 retColor;
		retColor.z = ((float)(ret & 0xff)) / 255.0f;
		retColor.y = ((float)((ret >> 0x8) & 0xff)) / 255.0f;
		retColor.x = ((float)((ret >> 0x10) & 0xff)) / 255.0f;
		retColor.w = (color.w) / 255.0f;
		
		factor = (float)(alpha)/100.0f;
		
		retColor = (float4)( retColor.xyz * factor + (1.0f - factor)* orig.xyz, orig.w);
		write_imagef(retImage, (int2)(w, h), retColor);
	}
}